/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.RecipeManagerAccessor;
import io.netty.handler.codec.DecoderException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.IMultiRecipe;

public class RecipeHelper {
    public static <C extends class_1860<?>> Optional<C> getRecipe(class_1863 manager, class_2960 name, Class<C> clazz) {
        return manager.method_8130(name).filter(clazz::isInstance).map(clazz::cast);
    }

    public static <I extends class_1263, T extends class_1860<I>, C extends T> List<C> getRecipes(class_1863 manager, class_3956<T> type, Class<C> clazz) {
        return ((RecipeManagerAccessor)manager).port_lib$byType(type).values().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static <I extends class_1263, T extends class_1860<I>, C extends T> List<C> getUIRecipes(class_1863 manager, class_3956<T> type, Class<C> clazz, Predicate<? super C> filter) {
        return ((RecipeManagerAccessor)manager).port_lib$byType(type).values().stream().filter(clazz::isInstance).map(clazz::cast).filter(filter).sorted(Comparator.comparing(class_1860::method_8114)).collect(Collectors.toList());
    }

    public static <C> List<C> getJEIRecipes(Stream<? extends class_1860<?>> recipes, Class<C> clazz) {
        return recipes.sorted((r1, r2) -> {
            boolean m1 = r1 instanceof IMultiRecipe;
            boolean m2 = r2 instanceof IMultiRecipe;
            if (m1 && !m2) {
                return 1;
            }
            if (!m1 && m2) {
                return -1;
            }
            return r1.method_8114().method_12833(r2.method_8114());
        }).flatMap(recipe -> {
            if (recipe instanceof IMultiRecipe) {
                return ((IMultiRecipe)recipe).getRecipes().stream();
            }
            return Stream.of(recipe);
        }).filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static <I extends class_1263, T extends class_1860<I>, C> List<C> getJEIRecipes(class_1863 manager, class_3956<T> type, Class<C> clazz) {
        return RecipeHelper.getJEIRecipes(((RecipeManagerAccessor)manager).port_lib$byType(type).values().stream(), clazz);
    }

    public static JsonObject serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", Objects.requireNonNull(class_7923.field_41173.method_10221((Object)stack.getFluid())).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        return json;
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        String fluidName = class_3518.method_15265((JsonObject)json, (String)"fluid");
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(fluidName));
        if (fluid == null || fluid == class_3612.field_15906) {
            throw new JsonSyntaxException("Unknown fluid " + fluidName);
        }
        int amount = class_3518.method_15260((JsonObject)json, (String)"amount");
        return new FluidStack(fluid, (long)amount);
    }

    public static <C> C deserializeItem(String name, String key, Class<C> clazz) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(name));
        if (item == null) {
            throw new JsonSyntaxException("Invalid " + key + ": Unknown item " + name + "'");
        }
        if (!clazz.isInstance(item)) {
            throw new JsonSyntaxException("Invalid " + key + ": must be " + clazz.getSimpleName());
        }
        return clazz.cast(item);
    }

    public static class_1792 readItem(class_2540 buffer) {
        return class_1792.method_7875((int)buffer.method_10816());
    }

    public static <T> T readItem(class_2540 buffer, Class<T> clazz) {
        class_1792 item = RecipeHelper.readItem(buffer);
        if (!clazz.isInstance(item)) {
            throw new DecoderException("Invalid item '" + String.valueOf(class_7923.field_41178.method_10221((Object)item)) + "', must be " + clazz.getSimpleName());
        }
        return clazz.cast(item);
    }

    public static void writeItem(class_2540 buffer, class_1935 item) {
        buffer.method_10804(class_1792.method_7880((class_1792)item.method_8389()));
    }

    private RecipeHelper() {
    }
}

